//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "SplitControl.h"

#define DCX_FLAGS (DCX_CACHE | DCX_CLIPSIBLINGS | DCX_LOCKWINDOWUPDATE)
//---------------------------------------------------------------------------
__fastcall TSplitControl::TSplitControl (
    TForm *AForm)
{
    unsigned short int pattern[] = {
        0xAAAA, 0x5555,
        0xAAAA, 0x5555,
        0xAAAA, 0x5555,
        0xAAAA, 0x5555,
    };

    FForm = AForm;
    ptn_bmp = CreateBitmap (8, 8, 1, 1, pattern);
    ptn_brsh = CreatePatternBrush (ptn_bmp);
}
//---------------------------------------------------------------------------
bool __fastcall TSplitControl::GetSizing (void)
{
    return (bool)FSplitControl;
}
//---------------------------------------------------------------------------
void __fastcall TSplitControl::DrawSizingLine (void)
{
    TPoint form_pos;

    form_pos = CtoC (FForm, FSplitControl, FSplit);

    PatBlt (FForm->Canvas->Handle, form_pos.x, form_pos.y,
        FSplitControl->Width, FSplitControl->Height,
        PATINVERT);
}
//---------------------------------------------------------------------------
TPoint __fastcall TSplitControl::CtoC (
    TControl *c1,
    TControl *c2,
    TPoint p)
{
    return c1->ScreenToClient (c2->ClientToScreen (p));
}
//---------------------------------------------------------------------------
void __fastcall TSplitControl::BeginSizing (
    TControl *ASplitControl,
    TControl *ATargetControl)
{
    FSplitControl = ASplitControl;
    FSizeTarget = ATargetControl;

    // Capture mouse movement
    SetCaptureControl (FSplitControl);

    FVertical = (ASplitControl->Width > ASplitControl->Height);
    if (FVertical) {
        FSplit = Point (0, ASplitControl->Top);
    } else {
        FSplit = Point (ASplitControl->Left, 0);
    }

    FForm->Canvas->Handle = GetDCEx (FForm->Handle, 0, DCX_FLAGS);
    SelectObject (FForm->Canvas->Handle, ptn_brsh);

    DrawSizingLine ();
}
//---------------------------------------------------------------------------
void __fastcall TSplitControl::ChangeSizing (int x, int y)
{
    if (FVertical) {
        if (FSplit.y != y) {
            DrawSizingLine ();
            FSplit.y = y;
            DrawSizingLine ();
        }
    } else {
        if (FSplit.x != x) {
            DrawSizingLine ();
            FSplit.x = x;
            DrawSizingLine ();
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TSplitControl::EndSizing (void)
{
    HDC dc;
    TPoint p;

    DrawSizingLine ();
    p = CtoC (FSizeTarget, FSplitControl, FSplit);
    SetCaptureControl (NULL);

    FSplitControl = NULL;

    dc = FForm->Canvas->Handle;
    ReleaseDC (FForm->Handle, dc);

    if (FVertical) {
        FSizeTarget->Height = p.y;
    } else {
        FSizeTarget->Width = p.x;
    }
}
//---------------------------------------------------------------------------

